package GraphicThreads;

import javafx.application.Platform;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Scanner;
import UI.MyPane;
import Back.Node;
import Back.Tree;






public class LoadThread <T extends Serializable & Comparable<T> > extends GraphicThread {
    String filename;
    String next_t;


    /**
     * konstruktor
     * @param _pane smernik na pane na ktorom bude pracovat
     * @param filename nazov suboru z ktoreho bude citat strom
     * @param next_t typ threadu ktory sa bude na konci volat ( string je jednoduchsi ako Class param )
     */
    public LoadThread(MyPane<T> _pane, String filename, String next_t) {
        pane = _pane;
        this.filename = filename;
        this.next_t = next_t;
        SLEEP_TIME = 1000;
    }

    /**
     * @return vrati nasledujuci thread
     */
    public String getNext_t(){
        return next_t;
    }

    /**
     * load funkcia stromu prerobena na animaciu
     * hlavny rozdiel je v tom ze originalna funkcia rekurzivne
     * vytvori node a potom ho priradi do synov
     * tento najprv vytvori node bez synov, ktory priradi otcovi
     * a vykresli sa
     * @param s scanner z ktoreho sa cita node
     * @param father otec ktoremu sa do synov prida novy vrchol
     */
    private void threadLoad( Scanner s, Node<T> father ){
        Node<T> node = new Node<T>();
        String riadok;

        s.nextLine();

        riadok = s.nextLine(); //"value" : "i",
        riadok = riadok.replace("\"value\" : ", "").trim();
        if ("null,".equals(riadok)) {
            node.setValue(null);
        } else {
            riadok = riadok.replace("\"", "");
            riadok = riadok.replace(",", "").trim();
            node.setValue((T) (riadok));
        }

        if ( father == null ){
            tree.setRoot(node);
        } else {
            father.insertNode(-1, node);
        }
        updateTree();


        riadok = s.nextLine(); //"sons" :  null
        riadok = riadok.replace("\"sons\" : ", "").trim();

        if (!riadok.equals("null")) {
            while (!riadok.equals("}") & !riadok.equals("]")) {
                threadLoad( s, node );

                riadok = s.nextLine().trim();
            }
            s.nextLine();
        }

        s.nextLine();
    }

    /**
     * otvori subor, zbytocny uvod jsonu preskoci
     * nasledne ak nemame nasledujuci thread, znamena
     * to ze nacitavame do stromu cislo 1
     * ak mame nacitavame do stromu cislo 2 a spustame
     * ziadany thread
     */
    @Override
    public void run() {
        try {
            File file = new File(filename + ".json");
            Scanner s = new Scanner(file);
            s.nextLine();
            s.nextLine();
            tree = new Tree();
            if ( getNext_t() == null ) {
                pane.setTree1(tree);
            } else {
                pane.setTree2(tree);
            }
            threadLoad(s, null);
        } catch (FileNotFoundException e){
            System.out.println("Wrong file name");
        }

        if ( next_t == null ){
            Platform.runLater(() -> {
                pane.end();
            });
        } else {
            switch (next_t) {
                case "join":
                    pane.setThread(new JoinThread(pane));
                    pane.getThread().run();
                    break;
                case "compare":
                    pane.setThread(new CompareThread(pane));
                    pane.getThread().run();
                    break;
            }
        }
    }
}
